from django import template
from django.template.defaultfilters import stringfilter
from django.utils.safestring import mark_safe
from app import settings as app_settings

from ..utils import all_settings, get_setting


register = template.Library()


@register.simple_tag
def settings(name):
    return get_setting(name)


@register.simple_tag(name='all_settings')
def allsettings():
    return all_settings()


@register.simple_tag(name='dj_settings')
def dj_settings(name):
    return getattr(app_settings, name, '')
